/*
  This file is part of GerFuSp.

  GerFuSp is free software: you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation, either version 3 of the License, or (at your option) any later
  version.

  GerFuSp is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  GerFuSp.  If not, see <http://www.gnu.org/licenses/>.
*/


#include "dlgices.h"

#include "mdlice.h"
#include <QMessageBox>


namespace GerFuSp {

  DlgIces* DlgIces::fTheDialog = NULL;

  const char* DlgIces::TITLE = "Ice types";

  DlgIces::DlgIces() {
    fBoxMain = NULL;
    fBoxData = NULL;
    fLbIces = NULL;
    fTblIces = NULL;
    fBoxCtrl = NULL;
    fBtAdd = NULL;
    fBtDelete = NULL;
    fBtAbort = NULL;
    fBtOK = NULL;
    setLayout(getBoxMain());
    setModal(true);
    setWindowTitle(tr(TITLE));
    resize(560, 240);
  } // DlgIces::DlgIces

  void DlgIces::closeEvent(QCloseEvent *aEvent) {
    doAbort();
  } // DlgIces::closeEvent

  void DlgIces::doAdd() {
    QModelIndex idx = MdlIce::getTheModel() -> newIce();
    getTblIces() -> setCurrentIndex(idx);
    getTblIces() -> edit(idx);
  } // DlgIces::doAdd

  void DlgIces::doAbort() {
    MdlIce::getTheModel() -> readAll();
    close();
  } // DlgIces::doAbort

  void DlgIces::doDelete() {
    int response = QMessageBox::question(
      this,
      tr("Question"),
      tr("Are you sure you wish to delete the selected ice type?"),
      QMessageBox::Yes,
      QMessageBox::No | QMessageBox::Default);
    if (response != QMessageBox::Yes) {
      return;
    } // if
    QTableView *table = getTblIces();
    QModelIndex idx = table -> currentIndex();
    MdlIce *model = MdlIce::getTheModel();
    table -> setCurrentIndex(model -> deleteIce(idx));
  } // DlgIces::doDelete

  void DlgIces::doOK() {
    MdlIce::getTheModel() -> writeAll();
    close();
  } // DlgIces::doOK

  QHBoxLayout* DlgIces::getBoxCtrl() {
    if (!fBoxCtrl) {
      fBoxCtrl = new QHBoxLayout();
      fBoxCtrl -> addWidget(getBtAdd());
      fBoxCtrl -> addWidget(getBtDelete());
      fBoxCtrl -> addStretch();
      fBoxCtrl -> addWidget(getBtAbort());
      fBoxCtrl -> addWidget(getBtOK());
    } // if
    return fBoxCtrl;
  } // DlgIces::getBoxCtrl

  QVBoxLayout* DlgIces::getBoxData() {
    if (!fBoxData) {
      fBoxData = new QVBoxLayout();
      fBoxData -> addWidget(getLbIces());
      fBoxData -> addWidget(getTblIces());
    } // if
    return fBoxData;
  } // DlgIces::getBoxData

  QVBoxLayout* DlgIces::getBoxMain() {
    if (!fBoxMain) {
      fBoxMain = new QVBoxLayout();
      fBoxMain -> addLayout(getBoxData());
      fBoxMain -> addLayout(getBoxCtrl());
    } // if
    return fBoxMain;
  } // DlgIces::getBoxMain

  QPushButton* DlgIces::getBtAbort() {
    if (!fBtAbort) {
      fBtAbort = new QPushButton(tr("Abort"));
      fBtAbort -> setShortcut(tr("Shift+Esc"));
      connect(fBtAbort, SIGNAL(clicked()), this, SLOT(doAbort()));
    } // if
    return fBtAbort;
  } // DlgIces::getBtAbort

  QPushButton* DlgIces::getBtAdd() {
    if (!fBtAdd) {
      fBtAdd = new QPushButton(tr("&Add"));
      connect(fBtAdd, SIGNAL(clicked()), this, SLOT(doAdd()));
    } // if
    return fBtAdd;
  } // DlgIces::getBtAdd

  QPushButton* DlgIces::getBtDelete() {
    if (!fBtDelete) {
      fBtDelete = new QPushButton(tr("&Delete"));
      connect(fBtDelete, SIGNAL(clicked()), this, SLOT(doDelete()));
    } // if
    return fBtDelete;
  } // DlgIces::getBtDelete

  QPushButton* DlgIces::getBtOK() {
    if (!fBtOK) {
      fBtOK = new QPushButton(tr("OK"));
      fBtOK -> setShortcut(tr("Shift+Return"));
      connect(fBtOK, SIGNAL(clicked()), this, SLOT(doOK()));
    } // if
    return fBtOK;
  } // DlgIces::getBtOK

  QLabel* DlgIces::getLbIces() {
    if (!fLbIces) {
      fLbIces = new QLabel(tr("L&ist of ice types:"));
      fLbIces -> setBuddy(getTblIces());
    } // if
    return fLbIces;
  } // DlgIces::getLbIces

  QTableView* DlgIces::getTblIces() {
    if (!fTblIces) {
      fTblIces = new QTableView();
      fTblIces -> setModel(MdlIce::getTheModel());
    } // if
    return fTblIces;
  } // DlgIces::getTblIces

  DlgIces* DlgIces::getTheDialog() {
    if (!fTheDialog) {
      fTheDialog = new DlgIces();
    } // if
    return fTheDialog;
  } // DlgIces::getTheDialog

} // GerFuSp
