/*
  This file is part of GerFuSp.

  GerFuSp is free software: you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation, either version 3 of the License, or (at your option) any later
  version.

  GerFuSp is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  GerFuSp.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef GERFUSP_DLGICES_H
#define GERFUSP_DLGICES_H


#include <QCloseEvent>
#include <QDialog>
#include <QHBoxLayout>
#include <QLabel>
#include <QPushButton>
#include <QTableView>
#include <QVBoxLayout>


namespace GerFuSp {


  class DlgIces: public QDialog {

    Q_OBJECT

    public:

      DlgIces();

      static DlgIces *getTheDialog();

    protected:

      void closeEvent(QCloseEvent *aEvent);

    private:

      QVBoxLayout *fBoxMain;
        QVBoxLayout *fBoxData;
	  QLabel *fLbIces;
	  QTableView *fTblIces;
	QHBoxLayout *fBoxCtrl;
	  QPushButton *fBtAdd;
	  QPushButton *fBtDelete;
	  QPushButton *fBtAbort;
	  QPushButton *fBtOK;

      QVBoxLayout *getBoxMain();
        QVBoxLayout *getBoxData();
	  QLabel *getLbIces();
	  QTableView *getTblIces();
	QHBoxLayout *getBoxCtrl();
	  QPushButton *getBtAdd();
	  QPushButton *getBtDelete();
	  QPushButton *getBtAbort();
	  QPushButton *getBtOK();

      static DlgIces *fTheDialog;

      static const char* TITLE;

    private slots:

      void doAdd();
      void doDelete();
      void doAbort();
      void doOK();

  }; // DlgIces


} // GerFuSp


#endif
