/*
  This file is part of GerFuSp.

  GerFuSp is free software: you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation, either version 3 of the License, or (at your option) any later
  version.

  GerFuSp is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  GerFuSp.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef GERFUSP_DLGRAMJET_H
#define GERFUSP_DLGRAMJET_H


#include "ramjet.h"
#include "recalcpath.h"
#include "ship.h"
#include <QButtonGroup>
#include <QComboBox>
#include <QDialog>
#include <QHBoxLayout>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QRadioButton>
#include <QTextEdit>
#include <QVBoxLayout>
#include <stdexcept>


namespace GerFuSp {


  class DlgRamjet: public QDialog {

    Q_OBJECT

    public:

      DlgRamjet();

      Ramjet *getRamjet();
      void setRamjet(Ramjet *aValue);

    protected:

      virtual void paintEvent(QPaintEvent *aEvent);

    private:

      Ramjet *fRamjet;

      QVBoxLayout *fBoxMain;
        QGridLayout *fGridData;
	  QLabel *fLbName;
	  QLineEdit *fLnName;
	  QLabel *fLbReaction;
	  QComboBox *fCbReaction;
	  QLabel *fLbOutput;
	  QLineEdit *fLnOutput;
	  QLabel *fLbShareGIM;
	  QLineEdit *fLnShareGIM;
	  QLabel *fLbUsedShare;
	  QLineEdit *fLnUsedShare;
	  QLabel *fLbShare;
	  QLineEdit *fLnShare;
	  QLabel *fLbEfficiency;
	  QLineEdit *fLnEfficiency;
	  QLabel *fLbConsumption;
	  QLineEdit *fLnConsumption;
	  QLabel *fLbStructure;
	  QLineEdit *fLnStructure;
	  QLabel *fLbIntakeRadius;
	  QLineEdit *fLnIntakeRadius;
	  QLabel *fLbPower;
	  QLineEdit *fLnPower;
	  QLabel *fLbDissipation;
	  QLineEdit *fLnDissipation;
	  QLabel *fLbThrust;
	  QLineEdit *fLnThrust;
	  QLabel *fLbExhVel_c;
	  QLineEdit *fLnExhVel_c;
	  QLabel *fLbExhVel_km_s;
	  QLineEdit *fLnExhVel_km_s;
	  QLabel *fLbTrvSpd_c;
	  QLineEdit *fLnTrvSpd_c;
	  QLabel *fLbTrvSpd_km_s;
	  QLineEdit *fLnTrvSpd_km_s;
	  QLabel *fLbAcceleration;
	  QLineEdit *fLnAcceleration;
	  QRadioButton *fRdRecalc_w_p;
	  QRadioButton *fRdRecalc_w_eta;
	  QRadioButton *fRdRecalc_P_p;
	  QRadioButton *fRdRecalc_P_eta;
	  QRadioButton *fRdRecalc_P_mu;
	QVBoxLayout *fBoxComments;
	  QLabel *fLbComments;
	  QTextEdit *fTextComments;
        QHBoxLayout *fBoxCtrl;
	  QPushButton *fBtApply;
	  QPushButton *fBtCancel;
	  QPushButton *fBtReload;
	  QPushButton *fBtSave;
	  QPushButton *fBtAbort;
	  QPushButton *fBtOK;

      QButtonGroup *fGrpRecalcExhVel;
      QButtonGroup *fGrpRecalcPower;

      RecalcPath *fPath_w_p;
      RecalcPath *fPath_w_eta;
      RecalcPath *fPath_P_p;
      RecalcPath *fPath_P_eta;
      RecalcPath *fPath_P_mu;

      QVBoxLayout *getBoxMain();
        QGridLayout *getGridData();
	  QLabel *getLbName();
	  QLineEdit *getLnName();
	  QLabel *getLbReaction();
	  QComboBox *getCbReaction();
	  QLabel *getLbOutput();
	  QLineEdit *getLnOutput();
	  QLabel *getLbShareGIM();
	  QLineEdit *getLnShareGIM();
	  QLabel *getLbUsedShare();
	  QLineEdit *getLnUsedShare();
	  QLabel *getLbShare();
	  QLineEdit *getLnShare();
	  QLabel *getLbEfficiency();
	  QLineEdit *getLnEfficiency();
	  QLabel *getLbConsumption();
	  QLineEdit *getLnConsumption();
	  QLabel *getLbStructure();
	  QLineEdit *getLnStructure();
	  QLabel *getLbIntakeRadius();
	  QLineEdit *getLnIntakeRadius();
	  QLabel *getLbPower();
	  QLineEdit *getLnPower();
	  QLabel *getLbDissipation();
	  QLineEdit *getLnDissipation();
	  QLabel *getLbThrust();
	  QLineEdit *getLnThrust();
	  QLabel *getLbExhVel_c();
	  QLineEdit *getLnExhVel_c();
	  QLabel *getLbExhVel_km_s();
	  QLineEdit *getLnExhVel_km_s();
	  QLabel *getLbTrvSpd_c();
	  QLineEdit *getLnTrvSpd_c();
	  QLabel *getLbTrvSpd_km_s();
	  QLineEdit *getLnTrvSpd_km_s();
	  QLabel *getLbAcceleration();
	  QLineEdit *getLnAcceleration();
	  QRadioButton *getRdRecalc_w_p();
	  QRadioButton *getRdRecalc_w_eta();
	  QRadioButton *getRdRecalc_P_p();
	  QRadioButton *getRdRecalc_P_eta();
	  QRadioButton *getRdRecalc_P_mu();
	QVBoxLayout *getBoxComments();
	  QLabel *getLbComments();
	  QTextEdit *getTextComments();
        QHBoxLayout *getBoxCtrl();
	  QPushButton *getBtApply();
	  QPushButton *getBtCancel();
	  QPushButton *getBtReload();
	  QPushButton *getBtSave();
	  QPushButton *getBtAbort();
	  QPushButton *getBtOK();

      QButtonGroup *getGrpRecalcExhVel();
      QButtonGroup *getGrpRecalcPower();

      RecalcPath *getPath_w_p();
      RecalcPath *getPath_w_eta();
      RecalcPath *getPath_P_p();
      RecalcPath *getPath_P_eta();
      RecalcPath *getPath_P_mu();

      void reInitCbReaction();

      Ship::RecalcRule getRecalcExhVel();
      Ship::RecalcRule getRecalcPower();

      QFont fFtRecalc;

      bool fRefreshing;

      void showException(const std::exception &aException);

      void resetTitle();

      static const char* TITLE_EMPTY;
      static const char* TITLE_FULL;
      static const int EDIT_WIDTH;

    private slots:

      void doRefresh();

      void doFetchName();
      void doReactionChanged();
      void doFetchUsedShare();
      void doFetchShare();
      void doFetchEfficiency();
      void doFetchConsumption();
      void doFetchStructure();
      void doFetchIntakeRadius();
      void doFetchPower();
      void doFetchDissipation();
      void doFetchThrust();
      void doFetchExhVel_c();
      void doFetchExhVel_km_s();
      void doFetchTrvSpd_c();
      void doFetchTrvSpd_km_s();
      void doFetchAcceleration();
      void doFetchComments();

      void doApply();
      void doReload();
      void doSave();
      void doAbort();
      void doOK();

  }; // DlgRamjet


} // GerFuSp


#endif
