/*
  This file is part of GerFuSp.

  GerFuSp is free software: you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation, either version 3 of the License, or (at your option) any later
  version.

  GerFuSp is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  GerFuSp.  If not, see <http://www.gnu.org/licenses/>.
*/


#include "dlgreactions.h"

#include "mdlreaction.h"
#include <QMessageBox>


namespace GerFuSp {

  DlgReactions* DlgReactions::fTheDialog = NULL;

  const char* DlgReactions::TITLE = "Reaction types";

  DlgReactions::DlgReactions() {
    fBoxMain = NULL;
    fBoxData = NULL;
    fLbReactions = NULL;
    fTblReactions = NULL;
    fBoxCtrl = NULL;
    fBtAdd = NULL;
    fBtDelete = NULL;
    fBtAbort = NULL;
    fBtOK = NULL;
    setLayout(getBoxMain());
    setWindowTitle(tr(TITLE));
    resize(480, 360);
  } // DlgReactions::DlgReactions

  void DlgReactions::closeEvent(QCloseEvent *aEvent) {
    doAbort();
  } // DlgReactions::closeEvent

  void DlgReactions::doAdd() {
    QModelIndex idx = MdlReaction::getTheModel() -> newReaction();
    getTblReactions() -> setCurrentIndex(idx);
    getTblReactions() -> edit(idx);
  } // DlgReactions::doAdd

  void DlgReactions::doAbort() {
    MdlReaction::getTheModel() -> readAll();
    close();
  } // DlgReactions::doAbort

  void DlgReactions::doDelete() {
    int response = QMessageBox::question(
      this,
      tr("Question"),
      tr("Are you sure you wish to delete the selected reaction type?"),
      QMessageBox::Yes,
      QMessageBox::No | QMessageBox::Default);
    if (response != QMessageBox::Yes) {
      return;
    } // if
    QTableView *table = getTblReactions();
    QModelIndex idx = table -> currentIndex();
    MdlReaction *model = MdlReaction::getTheModel();
    table -> setCurrentIndex(model -> deleteReaction(idx));
  } // DlgReactions::doDelete

  void DlgReactions::doOK() {
    MdlReaction::getTheModel() -> writeAll();
    close();
  } // DlgReactions::doOK

  QHBoxLayout* DlgReactions::getBoxCtrl() {
    if (!fBoxCtrl) {
      fBoxCtrl = new QHBoxLayout();
      fBoxCtrl -> addWidget(getBtAdd());
      fBoxCtrl -> addWidget(getBtDelete());
      fBoxCtrl -> addStretch();
      fBoxCtrl -> addWidget(getBtAbort());
      fBoxCtrl -> addWidget(getBtOK());
    } // if
    return fBoxCtrl;
  } // DlgReactions::getBoxCtrl

  QVBoxLayout* DlgReactions::getBoxData() {
    if (!fBoxData) {
      fBoxData = new QVBoxLayout();
      fBoxData -> addWidget(getLbReactions());
      fBoxData -> addWidget(getTblReactions());
    } // if
    return fBoxData;
  } // DlgReactions::getBoxData

  QVBoxLayout* DlgReactions::getBoxMain() {
    if (!fBoxMain) {
      fBoxMain = new QVBoxLayout();
      fBoxMain -> addLayout(getBoxData());
      fBoxMain -> addLayout(getBoxCtrl());
    } // if
    return fBoxMain;
  } // DlgReactions::getBoxMain

  QPushButton* DlgReactions::getBtAbort() {
    if (!fBtAbort) {
      fBtAbort = new QPushButton(tr("Abort"));
      fBtAbort -> setShortcut(tr("Shift+Esc"));
      connect(fBtAbort, SIGNAL(clicked()), this, SLOT(doAbort()));
    } // if
    return fBtAbort;
  } // DlgReactions::getBtAbort

  QPushButton* DlgReactions::getBtAdd() {
    if (!fBtAdd) {
      fBtAdd = new QPushButton(tr("&Add"));
      connect(fBtAdd, SIGNAL(clicked()), this, SLOT(doAdd()));
    } // if
    return fBtAdd;
  } // DlgReactions::getBtAdd

  QPushButton* DlgReactions::getBtDelete() {
    if (!fBtDelete) {
      fBtDelete = new QPushButton(tr("&Delete"));
      connect(fBtDelete, SIGNAL(clicked()), this, SLOT(doDelete()));
    } // if
    return fBtDelete;
  } // DlgReactions::getBtDelete

  QPushButton* DlgReactions::getBtOK() {
    if (!fBtOK) {
      fBtOK = new QPushButton(tr("OK"));
      fBtOK -> setShortcut(tr("Shift+Return"));
      connect(fBtOK, SIGNAL(clicked()), this, SLOT(doOK()));
    } // if
    return fBtOK;
  } // DlgReactions::getBtOK

  QLabel* DlgReactions::getLbReactions() {
    if (!fLbReactions) {
      fLbReactions = new QLabel(tr("L&ist of reaction types:"));
      fLbReactions -> setBuddy(getTblReactions());
    } // if
    return fLbReactions;
  } // DlgReactions::getLbReactions

  QTableView* DlgReactions::getTblReactions() {
    if (!fTblReactions) {
      fTblReactions = new QTableView();
      fTblReactions -> setModel(MdlReaction::getTheModel());
    } // if
    return fTblReactions;
  } // DlgReactions::getTblReactions

  DlgReactions* DlgReactions::getTheDialog() {
    if (!fTheDialog) {
      fTheDialog = new DlgReactions();
    } // if
    return fTheDialog;
  } // DlgReactions::getTheDialog

} // GerFuSp
