/*
  This file is part of GerFuSp.

  GerFuSp is free software: you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation, either version 3 of the License, or (at your option) any later
  version.

  GerFuSp is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  GerFuSp.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef GERFUSP_DLGROCKET_H
#define GERFUSP_DLGROCKET_H


#include "recalcpath.h"
#include "rocket.h"
#include "ship.h"
#include <QButtonGroup>
#include <QComboBox>
#include <QDialog>
#include <QGridLayout>
#include <QHBoxLayout>
#include <QLabel>
#include <QLineEdit>
#include <QPaintEvent>
#include <QPushButton>
#include <QRadioButton>
#include <QTextEdit>
#include <QVBoxLayout>
#include <stdexcept>


namespace GerFuSp {


  class DlgRocket: public QDialog {

    Q_OBJECT

    public:

      DlgRocket();

      Rocket *getRocket();
      void setRocket(Rocket *aValue);

    protected:

      virtual void paintEvent(QPaintEvent *aEvent);

    private:

      Rocket *fRocket;

      QVBoxLayout *fBoxMain;
	QGridLayout *fGridData;
	  QLabel *fLbName;
	  QLineEdit *fLnName;
	  QLabel *fLbReaction;
	  QComboBox *fCbReaction;
	  QLabel *fLbOutput;
	  QLineEdit *fLnOutput;
	  QLabel *fLbIce;
	  QComboBox *fCbIce;
	  QLabel *fLbShareReactive;
	  QLineEdit *fLnShareReactive;
	  QLabel *fLbShare;
	  QLineEdit *fLnShare;
	  QLabel *fLbAddPropPerFuel;
	  QLineEdit *fLnAddPropPerFuel;
	  QLabel *fLbEfficiency;
	  QLineEdit *fLnEfficiency;
	  QLabel *fLbConsumption;
	  QLineEdit *fLnConsumption;
	  QLabel *fLbStructure;
	  QLineEdit *fLnStructure;
	  QLabel *fLbStartEmptyRatio;
	  QLineEdit *fLnStartEmptyRatio;
	  QLabel *fLbStartingMass;
	  QLineEdit *fLnStartingMass;
	  QLabel *fLbAccelFull;
	  QLineEdit *fLnAccelFull;
	  QLabel *fLbAccelEmpty;
	  QLineEdit *fLnAccelEmpty;
	  QLabel *fLbFuelMass;
	  QLineEdit *fLnFuelMass;
	  QLabel *fLbIceQuantity;
	  QLineEdit *fLnIceQuantity;
	  QLabel *fLbPower;
	  QLineEdit *fLnPower;
	  QLabel *fLbDissipation;
	  QLineEdit *fLnDissipation;
	  QLabel *fLbThrust;
	  QLineEdit *fLnThrust;
	  QLabel *fLbExhVel_c;
	  QLineEdit *fLnExhVel_c;
	  QLabel *fLbExhVel_km_s;
	  QLineEdit *fLnExhVel_km_s;
	  QLabel *fLbTrvSpd_c;
	  QLineEdit *fLnTrvSpd_c;
	  QLabel *fLbTrvSpd_km_s;
	  QLineEdit *fLnTrvSpd_km_s;
	  QRadioButton *fRdRecalc_w_p;
	  QRadioButton *fRdRecalc_w_eta;
	  QRadioButton *fRdRecalc_v_w;
	  QRadioButton *fRdRecalc_v_R;
	  QRadioButton *fRdRecalc_P_p;
	  QRadioButton *fRdRecalc_P_eta;
	  QRadioButton *fRdRecalc_P_mu;
	  QLabel *fLbInertial;
	  QLabel *fLbOnBoard;
	  QLabel *fLbTotalFiringTime;
	  QLineEdit *fLnTotalFiringTimeInertial;
	  QLineEdit *fLnTotalFiringTimeOnBoard;
	  QLabel *fLbAccelTime;
	  QLineEdit *fLnAccelTimeInertial;
	  QLineEdit *fLnAccelTimeOnBoard;
	  QLabel *fLbDecelTime;
	  QLineEdit *fLnDecelTimeInertial;
	  QLineEdit *fLnDecelTimeOnBoard;
	  QLabel *fLbTotalFiringDistance_ly;
	  QLineEdit *fLnTotalFiringDistance_ly;
	  QLabel *fLbTotalFiringDistance_km;
	  QLineEdit *fLnTotalFiringDistance_km;
	  QLabel *fLbAccelDistance_ly;
	  QLineEdit *fLnAccelDistance_ly;
	  QLabel *fLbAccelDistance_km;
	  QLineEdit *fLnAccelDistance_km;
	  QLabel *fLbDecelDistance_ly;
	  QLineEdit *fLnDecelDistance_ly;
	  QLabel *fLbDecelDistance_km;
	  QLineEdit *fLnDecelDistance_km;
	QVBoxLayout *fBoxComments;
	  QLabel *fLbComments;
	  QTextEdit *fTextComments;
	QHBoxLayout *fBoxCtrl;
	  QPushButton *fBtApply;
	  QPushButton *fBtCancel;
	  QPushButton *fBtReload;
	  QPushButton *fBtSave;
	  QPushButton *fBtAbort;
	  QPushButton *fBtOK;

      QButtonGroup *fGrpRecalcExhVel;
      QButtonGroup *fGrpRecalcTrvSpd;
      QButtonGroup *fGrpRecalcPower;

      RecalcPath *fPath_w_p;
      RecalcPath *fPath_w_eta;
      RecalcPath *fPath_v_w;
      RecalcPath *fPath_v_R;
      RecalcPath *fPath_P_p;
      RecalcPath *fPath_P_eta;
      RecalcPath *fPath_P_mu;

      QVBoxLayout *getBoxMain();
	QGridLayout *getGridData();
	  QLabel *getLbName();
	  QLineEdit *getLnName();
	  QLabel *getLbReaction();
	  QComboBox *getCbReaction();
	  QLabel *getLbOutput();
	  QLineEdit *getLnOutput();
	  QLabel *getLbIce();
	  QComboBox *getCbIce();
	  QLabel *getLbShareReactive();
	  QLineEdit *getLnShareReactive();
	  QLabel *getLbShare();
	  QLineEdit *getLnShare();
	  QLabel *getLbAddPropPerFuel();
	  QLineEdit *getLnAddPropPerFuel();
	  QLabel *getLbEfficiency();
	  QLineEdit *getLnEfficiency();
	  QLabel *getLbConsumption();
	  QLineEdit *getLnConsumption();
	  QLabel *getLbStructure();
	  QLineEdit *getLnStructure();
	  QLabel *getLbStartEmptyRatio();
	  QLineEdit *getLnStartEmptyRatio();
	  QLabel *getLbStartingMass();
	  QLineEdit *getLnStartingMass();
	  QLabel *getLbAccelFull();
	  QLineEdit *getLnAccelFull();
	  QLabel *getLbAccelEmpty();
	  QLineEdit *getLnAccelEmpty();
	  QLabel *getLbFuelMass();
	  QLineEdit *getLnFuelMass();
	  QLabel *getLbIceQuantity();
	  QLineEdit *getLnIceQuantity();
	  QLabel *getLbPower();
	  QLineEdit *getLnPower();
	  QLabel *getLbDissipation();
	  QLineEdit *getLnDissipation();
	  QLabel *getLbThrust();
	  QLineEdit *getLnThrust();
	  QLabel *getLbExhVel_c();
	  QLineEdit *getLnExhVel_c();
	  QLabel *getLbExhVel_km_s();
	  QLineEdit *getLnExhVel_km_s();
	  QLabel *getLbTrvSpd_c();
	  QLineEdit *getLnTrvSpd_c();
	  QLabel *getLbTrvSpd_km_s();
	  QLineEdit *getLnTrvSpd_km_s();
	  QRadioButton *getRdRecalc_w_p();
	  QRadioButton *getRdRecalc_w_eta();
	  QRadioButton *getRdRecalc_v_w();
	  QRadioButton *getRdRecalc_v_R();
	  QRadioButton *getRdRecalc_P_p();
	  QRadioButton *getRdRecalc_P_eta();
	  QRadioButton *getRdRecalc_P_mu();
	  QLabel *getLbInertial();
	  QLabel *getLbOnBoard();
	  QLabel *getLbTotalFiringTime();
	  QLineEdit *getLnTotalFiringTimeInertial();
	  QLineEdit *getLnTotalFiringTimeOnBoard();
	  QLabel *getLbAccelTime();
	  QLineEdit *getLnAccelTimeInertial();
	  QLineEdit *getLnAccelTimeOnBoard();
	  QLabel *getLbDecelTime();
	  QLineEdit *getLnDecelTimeInertial();
	  QLineEdit *getLnDecelTimeOnBoard();
	  QLabel *getLbTotalFiringDistance_ly();
	  QLineEdit *getLnTotalFiringDistance_ly();
	  QLabel *getLbTotalFiringDistance_km();
	  QLineEdit *getLnTotalFiringDistance_km();
	  QLabel *getLbAccelDistance_ly();
	  QLineEdit *getLnAccelDistance_ly();
	  QLabel *getLbAccelDistance_km();
	  QLineEdit *getLnAccelDistance_km();
	  QLabel *getLbDecelDistance_ly();
	  QLineEdit *getLnDecelDistance_ly();
	  QLabel *getLbDecelDistance_km();
	  QLineEdit *getLnDecelDistance_km();
	QVBoxLayout *getBoxComments();
	  QLabel *getLbComments();
	  QTextEdit *getTextComments();
	QHBoxLayout *getBoxCtrl();
	  QPushButton *getBtApply();
	  QPushButton *getBtCancel();
	  QPushButton *getBtReload();
	  QPushButton *getBtSave();
	  QPushButton *getBtAbort();
	  QPushButton *getBtOK();

      QButtonGroup *getGrpRecalcExhVel();
      QButtonGroup *getGrpRecalcTrvSpd();
      QButtonGroup *getGrpRecalcPower();

      RecalcPath *getPath_w_p();
      RecalcPath *getPath_w_eta();
      RecalcPath *getPath_v_w();
      RecalcPath *getPath_v_R();
      RecalcPath *getPath_P_p();
      RecalcPath *getPath_P_eta();
      RecalcPath *getPath_P_mu();

      void reInitCbReaction();
      void reInitCbIce();

      Ship::RecalcRule getRecalcExhVel();
      Ship::RecalcRule getRecalcTrvSpd();
      Ship::RecalcRule getRecalcPower();

      QFont fFtRecalc;

      bool fRefreshing;

      void showException(const std::exception &aException);

      void resetTitle();

      static const char* TITLE_EMPTY;
      static const char* TITLE_FULL;
      static const int EDIT_WIDTH;

    private slots:

      void doRefresh();

      void doFetchName();
      void doReactionChanged();
      void doIceChanged();
      void doFetchAddPropPerFuel();
      void doFetchReactiveShare();
      void doFetchEfficiency();
      void doFetchConsumption();
      void doFetchStructure();
      void doFetchStartEmptyRatio();
      void doFetchStartingMass();
      void doFetchFuelMass();
      void doFetchPower();
      void doFetchDissipation();
      void doFetchThrust();
      void doFetchExhVel_c();
      void doFetchExhVel_km_s();
      void doFetchTrvSpd_c();
      void doFetchTrvSpd_km_s();
      void doFetchAccelFull();
      void doFetchAccelEmpty();
      void doFetchIceQuantity();
      void doFetchTotalFiringDistance_ly();
      void doFetchTotalFiringDistance_km();
      void doFetchAccelDistance_ly();
      void doFetchAccelDistance_km();
      void doFetchDecelDistance_ly();
      void doFetchDecelDistance_km();
      void doFetchComments();

      void doApply();
      void doReload();
      void doSave();
      void doAbort();
      void doOK();

  }; // DlgRocket


} // GerFuSp


#endif
