/*
  This file is part of GerFuSp.

  GerFuSp is free software: you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation, either version 3 of the License, or (at your option) any later
  version.

  GerFuSp is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  GerFuSp.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef GERFUSP_GERFUSPBASE_H
#define GERFUSP_GERFUSPBASE_H


#include <gerq/dataobject.h>
#include <QComboBox>
#include <QLineEdit>
#include <QString>
#include <QTableView>
#include <QWidget>


namespace GerFuSp {

  class Reaction;
  class Ice;
  class Ship;
    class Rocket;
    class Ramjet;

  extern int IntOrExc(const QString &aValue);
  extern double DoubleOrExc(const QString &aValue);

  extern void initLineEdit(QLineEdit *aEdit, const QString &aText,
    bool aReadOnly = false);
  extern void initLineEditF(QLineEdit *aEdit, double aValue,
    const char* aFormat, double aMin = 0.0, double aMax = 1.0e+32);
  extern double dblFromLineEdit(QLineEdit *aEdit);

  extern int curTableRow(QTableView *aTable);
  extern void gotoTableRow(QTableView *aTable, int aRow);

  extern void gotoComboItem(QComboBox *aCombo, GerQ::DataObject *aData);

  extern void reInitCbReaction(QComboBox *aCombo, const QString &aNoneStr);

  extern QString IDToStr(const QVariant &aID);
  extern QString DurationToStr(double aDuration);

} // GerFuSp


#endif
