/*
  This file is part of GerFuSp.

  GerFuSp is free software: you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation, either version 3 of the License, or (at your option) any later
  version.

  GerFuSp is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  GerFuSp.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef GERFUSP_ICE_H
#define GERFUSP_ICE_H


#include "gerfuspbase.h"
#include "rocket.h"
#include <gerq/dataobject.h>
#include <gerq/instcontainer.h>
#include <gerq/sqldataadapter.h>
#include <QMap>
#include <QString>


namespace GerFuSp {


  class Ice: public GerQ::DataObject {

    public:

      Ice();
      virtual ~Ice();

      virtual void erase();

      QString getName();
      void setName(const QString &aValue);
      QString getFormulaGUI();
      void setFormulaGUI(const QString &aValue);
      QString getFormulaTeX();
      void setFormulaTeX(const QString &aValue);
      int getNucleonsReactive();
      void setNucleonsReactive(int aValue);
      int getNucleonsTotal();
      void setNucleonsTotal(int aValue);
      double getReactiveShare();
      double getDensity();
      void setDensity(double aValue);
      double getDensity_g_cm3();
      void setDensity_g_cm3(double aValue);

      void addRocket(Rocket *aRocket);
      void removeRocket(Rocket *aRocket);

      static GerQ::InstContainer *getTheContainer();

    private:

      QString fName;
      QString fFormulaGUI;
      QString fFormulaTeX;
      int fNucleonsReactive;
      int fNucleonsTotal;
      double fDensity;

      QMap <QString, Rocket*> fRockets;

      static GerQ::InstContainer *fTheContainer;

      static GerQ::DataObject *doCreate();
      static void doRead(GerQ::DataObject *aData, GerQ::SqlDataAdapter *aSql);
      static void doWrite(GerQ::DataObject *aData, GerQ::SqlDataAdapter *aSql);

      static const char* TABLE;
      static const char* KEY_ID;
      static const char* KEY_NAME;
      static const char* KEY_FORMULAGUI;
      static const char* KEY_FORMULATEX;
      static const char* KEY_NUCLEONSREACTIVE;
      static const char* KEY_NUCLEONSTOTAL;
      static const char* KEY_DENSITY;

  }; // Ice


} // GerFuSp


#endif
