/*
  This file is part of GerFuSp.

  GerFuSp is free software: you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation, either version 3 of the License, or (at your option) any later
  version.

  GerFuSp is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  GerFuSp.  If not, see <http://www.gnu.org/licenses/>.
*/


#include "wndmain.h"
#include <gerq/datacontainer.h>
#include <QApplication>
#include <QFile>
#include <QSqlDatabase>
#include <QString>


const char* DBFILENAME = ".gerfusp.db";
const char* DBTEMPLATE = "/usr/share/gerfusp/template.db";

const char* ERRMSG_1 = "Usage: gerfusp [-db <sqlite db file name>]\n";
const char* ERRMSG_2 = "Unable to open file \"%s\" for reading. Aborting.\n";
const char* ERRMSG_3 = "Unable to open file \"%s\" for writing. Aborting.\n";


int opendb(int argc, char** argv) {
  QSqlDatabase db;
  QString dbdriver = "QSQLITE";
  QString dbname = QString().sprintf("%s/%s", getenv("HOME"), DBFILENAME);
  QString host = "";
  QString user = "";
  QString pwd = "";
  switch (argc) {
    case 3:
      if (strcmp(argv[1], "-db") == 0) {
        dbname = argv[2];
      /*!!! TODO:
       * Langfristig: Stattdessen Configfile für Zugriff auf anderen
       * DB-Server als Eingabeparameter akzeptieren. (Vgl. gerskymap)
       */
      } else {
	printf(ERRMSG_1);
	return 1;
      } // if
      break;
    case 1:
      break;
    default:
      printf(ERRMSG_1);
      return 1;
  } // switch
  db = QSqlDatabase::addDatabase(dbdriver);
  db.setHostName(host);
  db.setDatabaseName(dbname);
  db.setUserName(user);
  db.setPassword(pwd);
  if (dbdriver == "QSQLITE") {
    QFile dbfile(dbname);
    if (!dbfile.exists()) {
      QFile dbtemplate(DBTEMPLATE);
      if (!dbtemplate.open(QIODevice::ReadOnly)) {
        printf(ERRMSG_2, DBTEMPLATE);
	return 2;
      } // if
      if (!dbfile.open(QIODevice::WriteOnly)) {
        printf(ERRMSG_3, qPrintable(dbname));
	return 3;
      } // if
      dbfile.write(dbtemplate.readAll());
      dbfile.close();
      dbtemplate.close();
    } // if
    GerQ::DataContainer::setDefaultNullID("");
  } // if
  db.open();
  return 0;
} // opendb

int main(int argc, char** argv) {
  int errcode = opendb(argc, argv);
  if (errcode) {
    return errcode;
  } // if
  QApplication app(argc, argv);
  GerFuSp::WndMain *wndmain = GerFuSp::WndMain::getTheWindow();
  wndmain -> show();
  return app.exec();
} // main
