/*
  This file is part of GerFuSp.

  GerFuSp is free software: you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation, either version 3 of the License, or (at your option) any later
  version.

  GerFuSp is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  GerFuSp.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef GERFUSP_MDLICE_H
#define GERFUSP_MDLICE_H


#include "ice.h"
#include <QAbstractTableModel>
#include <QList>


namespace GerFuSp {


  class MdlIce: public QAbstractTableModel {

    Q_OBJECT

    public:

      MdlIce();

      int rowCount(const QModelIndex &aParent) const;
      int columnCount(const QModelIndex &aParent) const;
      QVariant data(const QModelIndex &aIndex, int aRole) const;
      bool setData(const QModelIndex &aIndex, const QVariant &aValue,
	int aRole = Qt::EditRole);
      QVariant headerData(int aSection, Qt::Orientation aOrientation,
        int aRole) const;
      Qt::ItemFlags flags(const QModelIndex &aIndex) const;

      void readAll();
      void writeAll();
      QModelIndex newIce();
      QModelIndex deleteIce(const QModelIndex &aIndex);

      static MdlIce *getTheModel();

    private:

      QList <Ice*> fIces;

      void addIce(Ice *aIce);
      void removeIce(Ice *aIce);

      static MdlIce *fTheModel;

      static const int fColCount;

      static const int COL_NAME;
      static const int COL_FORMULAGUI;
      static const int COL_FORMULATEX;
      static const int COL_NUCLEONSREACTIVE;
      static const int COL_NUCLEONSTOTAL;
      static const int COL_DENSITY;

      static const char* HDR_NAME;
      static const char* HDR_FORMULAGUI;
      static const char* HDR_FORMULATEX;
      static const char* HDR_NUCLEONSREACTIVE;
      static const char* HDR_NUCLEONSTOTAL;
      static const char* HDR_DENSITY;

  }; // MdlIce


} // GerFuSp


#endif
