/*
  This file is part of GerFuSp.

  GerFuSp is free software: you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation, either version 3 of the License, or (at your option) any later
  version.

  GerFuSp is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  GerFuSp.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef GERFUSP_MDLREACTION_H
#define GERFUSP_MDLREACTION_H


#include "reaction.h"
#include <QAbstractTableModel>
#include <QList>


namespace GerFuSp {


  class MdlReaction: public QAbstractTableModel {

    Q_OBJECT

    public:

      MdlReaction();

      int rowCount(const QModelIndex &aParent) const;
      int columnCount(const QModelIndex &aParent) const;
      QVariant data(const QModelIndex &aIndex, int aRole) const;
      bool setData(const QModelIndex &aIndex, const QVariant &aValue,
	int aRole = Qt::EditRole);
      QVariant headerData(int aSection, Qt::Orientation aOrientation,
        int aRole) const;
      Qt::ItemFlags flags(const QModelIndex &aIndex) const;

      void readAll();
      void writeAll();
      QModelIndex newReaction();
      QModelIndex deleteReaction(const QModelIndex &aIndex);

      static MdlReaction *getTheModel();

    private:

      QList <Reaction*> fReactions;

      void addReaction(Reaction *aReaction);
      void removeReaction(Reaction *aReaction);

      static MdlReaction *fTheModel;

      static const int fColCount;

      static const int COL_NAMEGUI;
      static const int COL_NAMETEX;
      static const int COL_OUTPUT;
      static const int COL_SHAREGIM;

      static const char* HDR_NAMEGUI;
      static const char* HDR_NAMETEX;
      static const char* HDR_OUTPUT;
      static const char* HDR_SHAREGIM;

  }; // MdlReaction


} // GerFuSp


#endif
