/*
  This file is part of GerFuSp.

  GerFuSp is free software: you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation, either version 3 of the License, or (at your option) any later
  version.

  GerFuSp is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  GerFuSp.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef GERFUSP_MDLSHIP_H
#define GERFUSP_MDLSHIP_H


#include "ramjet.h"
#include "rocket.h"
#include "ship.h"
#include <QAbstractTableModel>
#include <QList>


namespace GerFuSp {


  class MdlShip: public QAbstractTableModel {

    Q_OBJECT

    public:

      MdlShip();

      int rowCount(const QModelIndex &aParent) const;
      int columnCount(const QModelIndex &aParent) const;
      QVariant data(const QModelIndex &aIndex, int aRole) const;
      QVariant headerData(int aSection, Qt::Orientation aOrientation,
        int aRole) const;

      Rocket *newRocket(int &aIndex);
      Ramjet *newRamjet(int &aIndex);
      Ship *getShipAt(int aIndex);
      QModelIndex deleteShip(const QModelIndex &aIndex);

      int addShip(Ship *aShip);
      void removeShip(Ship *aShip);

      static MdlShip *getTheModel();

    private:

      QList <Ship*> fShips;

      static MdlShip *fTheModel;

      static const int fColCount;

      static const int COL_NAME;
      static const int COL_TYPE;
      static const int COL_SPECIFICA;
      static const int COL_REACTION;
      static const int COL_OUTPUT;
      static const int COL_REACTSHARE;
      static const int COL_EFFICIENCY;
      static const int COL_EXHVEL;
      static const int COL_TRAVELSPD;
      static const int COL_COMMENTS;

      static const char* HDR_NAME;
      static const char* HDR_TYPE;
      static const char* HDR_SPECIFICA;
      static const char* HDR_REACTION;
      static const char* HDR_OUTPUT;
      static const char* HDR_REACTSHARE;
      static const char* HDR_EFFICIENCY;
      static const char* HDR_EXHVEL;
      static const char* HDR_TRAVELSPD;
      static const char* HDR_COMMENTS;

  }; // MdlShip


} // GerFuSp


#endif
