/*
  This file is part of GerFuSp.

  GerFuSp is free software: you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation, either version 3 of the License, or (at your option) any later
  version.

  GerFuSp is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  GerFuSp.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef GERFUSP_RAMJET_H
#define GERFUSP_RAMJET_H


#include "ship.h"
#include <gerq/instcontainer.h>
#include <gerq/sqldataadapter.h>


namespace GerFuSp {


  class Ramjet: public Ship {

    public:

      Ramjet();

      double getReactiveShare();
      void setReactiveShare(double aValue);
      double getThrust();
      void setThrust(double aValue);
      double getTravelSpeed_c();
      void setTravelSpeed_c(double aValue, RecalcRule aRule);

      double getIntakeRadius();
      void setIntakeRadius(double aValue);
      double getIntakeRadius_km();
      void setIntakeRadius_km(double aValue);
      double getUsedShare();
      void setUsedShare(double aValue);

      QString getTypeName();
      QString getSpecifica();

      static GerQ::InstContainer *getTheContainer();

    private:

      double fIntakeRadius;
      double fUsedShare;
      bool fFiltered;

      static GerQ::InstContainer *fTheContainer;

      static GerQ::DataObject *doCreate();
      static void doRead(GerQ::DataObject *aData, GerQ::SqlDataAdapter *aSql);
      static void doWrite(GerQ::DataObject *aData, GerQ::SqlDataAdapter *aSql);

      static const char* TABLE;
      static const char* KEY_ID;
      static const char* KEY_INTAKERADIUS;
      static const char* KEY_USEDSHARE;

  }; // Ramjet


} // GerFuSp


#endif
