/*
  This file is part of GerFuSp.

  GerFuSp is free software: you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation, either version 3 of the License, or (at your option) any later
  version.

  GerFuSp is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  GerFuSp.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef GERFUSP_REACTION_H
#define GERFUSP_REACTION_H


#include "gerfuspbase.h"
#include "ship.h"
#include <gerq/dataobject.h>
#include <gerq/instcontainer.h>
#include <gerq/sqldataadapter.h>
#include <QMap>
#include <QString>


namespace GerFuSp {


  class Reaction: public GerQ::DataObject {

    public:

      Reaction();
      virtual ~Reaction();

      virtual void erase();

      QString getNameGUI();
      void setNameGUI(const QString &aValue);
      QString getNameTeX();
      void setNameTeX(const QString &aValue);
      QString getNamePrinted();
      double getOutput();
      void setOutput(double aValue);
      double getShareGIM();
      void setShareGIM(double aValue);

      double getLorentzFactor(double aReactiveShare, double aEfficiency);

      double getExhaustVelocity(double aReactiveShare, double aEfficiency);
      double getExhaustVelocity_c(double aReactiveShare, double aEfficiency);
      double getExhaustVelocity_km_s(double aReactiveShare,
        double aEfficiency);

      void addShip(Ship *aShip);
      void removeShip(Ship *aShip);

      static GerQ::InstContainer *getTheContainer();

    private:

      QString fNameGUI;
      QString fNameTeX;
      double fOutput;
      double fShareGIM;

      QMap <QString, Ship*> fShips;

      static GerQ::DataObject *doCreate();
      static void doRead(GerQ::DataObject *aData, GerQ::SqlDataAdapter *aSql);
      static void doWrite(GerQ::DataObject *aData, GerQ::SqlDataAdapter *aSql);

      static GerQ::InstContainer *fTheContainer;

      static const char* TABLE;
      static const char* KEY_ID;
      static const char* KEY_NAMEGUI;
      static const char* KEY_NAMETEX;
      static const char* KEY_OUTPUT;
      static const char* KEY_SHAREGIM;

  }; // Reaction


} // GerFuSp


#endif
