/*
  This file is part of GerFuSp.

  GerFuSp is free software: you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation, either version 3 of the License, or (at your option) any later
  version.

  GerFuSp is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  GerFuSp.  If not, see <http://www.gnu.org/licenses/>.
*/


#include "recalcpath.h"


namespace GerFuSp {

  RecalcPath::RecalcPath(QGridLayout *aGrid, int aRowFrom, int aColFrom,
    int aRowTo, int aColTo, const QColor &aColor, Qt::Orientation aOrientation)
  {
    fGrid = aGrid;
    fRowFrom = aRowFrom;
    fColFrom = aColFrom;
    fRowTo = aRowTo;
    fColTo = aColTo;
    fColor = aColor;
    fOrientation = aOrientation;
  } // RecalcPath::RecalcPath

  void RecalcPath::draw(QPainter &aPainter, bool aActive) {
    QPen pen;
    if (aActive) {
      pen = QPen(fColor, 2, Qt::SolidLine, Qt::FlatCap);
    } else {
      pen = QPen(fColor, 1, Qt::DotLine, Qt::FlatCap);
    } // if
    QBrush brush = QBrush(fColor, Qt::SolidPattern);
    aPainter.setPen(pen);
    aPainter.setBrush(brush);
    QRect rFrom = fGrid -> cellRect(fRowFrom, fColFrom);
    QRect rTo = fGrid -> cellRect(fRowTo, fColTo);
    int xFrom, yFrom, xTo, yTo;
    QPolygon arrow(3);
    if (fRowFrom == fRowTo && fColFrom == fColTo) {
      return;
    } else if (fRowFrom != fRowTo && fColFrom != fColTo) {
      if (fRowFrom < fRowTo) {
	yFrom = rFrom.bottom();
	yTo = rTo.top();
      } else {
	yFrom = rFrom.top();
	yTo = rTo.bottom();
      } // if
      switch (fOrientation) {
        case Qt::Vertical:
	  xFrom = (rFrom.left() + rFrom.right()) / 2;
	  if (fColFrom < fColTo) {
	    xTo = rTo.left();
	    arrow[0] = QPoint(xTo, yTo);
	    arrow[1] = QPoint(xTo - 8, yTo - 4);
	    arrow[2] = QPoint(xTo - 8, yTo + 4);
	  } else {
	    xTo = rTo.right();
	    arrow[0] = QPoint(xTo, yTo);
	    arrow[1] = QPoint(xTo + 8, yTo - 4);
	    arrow[2] = QPoint(xTo + 8, yTo + 4);
	  } // if
	  aPainter.drawLine(xFrom, yFrom, xFrom, yTo);
	  aPainter.drawLine(xFrom, yTo, xTo, yTo);
	  break;
	case Qt::Horizontal:
	  if (fColFrom < fColTo) {
	    xFrom = rFrom.right();
	  } else {
	    xFrom = rFrom.left();
	  } // if
	  xTo = (rTo.left() + rTo.right()) / 2;
	  aPainter.drawLine(xFrom, yFrom, xTo, yFrom);
	  aPainter.drawLine(xTo, yFrom, xTo, yTo);
	  arrow[0] = QPoint(xTo, yTo);
	  if (yTo > yFrom) {
	    arrow[1] = QPoint(xTo - 4, yTo - 8);
	    arrow[2] = QPoint(xTo + 4, yTo - 8);
	  } else {
	    arrow[1] = QPoint(xTo - 4, yTo + 8);
	    arrow[2] = QPoint(xTo + 4, yTo + 8);
	  } // if
	  break;
      } // switch
    } else {
      if (fRowFrom == fRowTo) {
	yFrom = rFrom.bottom();
	yTo = yFrom;
	if (fColFrom < fColTo) {
	  xFrom = rFrom.right();
	  xTo = rTo.left();
	  arrow[0] = QPoint(xTo, yTo);
	  arrow[1] = QPoint(xTo - 8, yTo - 4);
	  arrow[2] = QPoint(xTo - 8, yTo + 4);
	} else {
	  xFrom = rFrom.left();
	  xTo = rTo.right();
	  arrow[0] = QPoint(xTo, yTo);
	  arrow[1] = QPoint(xTo + 8, yTo - 4);
	  arrow[2] = QPoint(xTo + 8, yTo + 4);
	} // if
      } else if (fColFrom == fColTo) {
	xFrom = (rFrom.left() + rFrom.right()) / 2;
	xTo = xFrom;
	if (fRowFrom < fRowTo) {
	  yFrom = rFrom.bottom();
	  yTo = rTo.top();
	  arrow[0] = QPoint(xTo, yTo);
	  arrow[1] = QPoint(xTo - 4, yTo - 8);
	  arrow[2] = QPoint(xTo + 4, yTo - 8);
	} else {
	  yFrom = rFrom.top();
	  yTo = rTo.bottom();
	  arrow[0] = QPoint(xTo, yTo);
	  arrow[1] = QPoint(xTo - 4, yTo + 8);
	  arrow[2] = QPoint(xTo + 4, yTo + 8);
	} // if
      } // if
      aPainter.drawLine(xFrom, yFrom, xTo, yTo);
    } // if
    if (aActive) {
      aPainter.drawPolygon(arrow);
    } // if
  } // RecalcPath::draw

} // GerFuSp
