/*
  This file is part of GerFuSp.

  GerFuSp is free software: you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation, either version 3 of the License, or (at your option) any later
  version.

  GerFuSp is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  GerFuSp.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef GERFUSP_ROCKET_H
#define GERFUSP_ROCKET_H


#include "ice.h"
#include "ship.h"
#include <gerq/instcontainer.h>
#include <gerq/sqldataadapter.h>


namespace GerFuSp {


  class Rocket: public Ship {

    public:

      Rocket();
      virtual ~Rocket();

      double getTravelSpeed_c();
      void setTravelSpeed_c(double aValue, RecalcRule aRule);
      double getThrust();
      void setThrust(double aValue);

      double getRatioFullEmpty();
      void setRatioFullEmpty(double aValue);
      double getReactiveShare();
      void setReactiveShare(double aValue);
      double getAddPropPerFuel();
      void setAddPropPerFuel(double aValue);
      Ice *getIce();
      void setIce(Ice *aValue);

      QString getTypeName();
      QString getSpecifica();

      double getStartingMass();
      void setStartingMass(double aValue);
      double getStartingMass_t();
      void setStartingMass_t(double aValue);
      double getFuelMass();
      void setFuelMass(double aValue);
      double getFuelMass_t();
      void setFuelMass_t(double aValue);
      double getIceDiameter();
      void setIceDiameter(double aValue);
      double getIceDiameter_km();
      void setIceDiameter_km(double aValue);

      double getAccelEmpty();
      void setAccelEmpty(double aValue);
      double getAccelEmpty_g();
      void setAccelEmpty_g(double aValue);
      double getAccelFull();
      void setAccelFull(double aValue);
      double getAccelFull_g();
      void setAccelFull_g(double aValue);

      double getAccelTimeOnBoard();
      double getDecelTimeOnBoard();
      double getTotalFiringTimeOnBoard();
      double getAccelTimeInertial();
      double getDecelTimeInertial();
      double getTotalFiringTimeInertial();

      double getAccelDistance();
      void setAccelDistance(double aValue);
      double getAccelDistance_ly();
      void setAccelDistance_ly(double aValue);
      double getAccelDistance_km();
      void setAccelDistance_km(double aValue);
      double getDecelDistance();
      void setDecelDistance(double aValue);
      double getDecelDistance_ly();
      void setDecelDistance_ly(double aValue);
      double getDecelDistance_km();
      void setDecelDistance_km(double aValue);
      double getTotalFiringDistance();
      void setTotalFiringDistance(double aValue);
      double getTotalFiringDistance_ly();
      void setTotalFiringDistance_ly(double aValue);
      double getTotalFiringDistance_km();
      void setTotalFiringDistance_km(double aValue);

      static GerQ::InstContainer *getTheContainer();

    private:

      double fAddPropPerFuel;
      double fRatioFullEmpty;
      Ice *fIce;

      static GerQ::InstContainer *fTheContainer;

      static GerQ::DataObject *doCreate();
      static void doRead(GerQ::DataObject *aData, GerQ::SqlDataAdapter *aSql);
      static void doWrite(GerQ::DataObject *aData, GerQ::SqlDataAdapter *aSql);

      static const char* TABLE;
      static const char* KEY_ID;
      static const char* KEY_ADDPROPPERFUEL;
      static const char* KEY_RATIOFULLEMPTY;
      static const char* KEY_ICE;

  }; // Rocket


} // GerFuSp


#endif
