/*
  This file is part of GerFuSp.

  GerFuSp is free software: you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation, either version 3 of the License, or (at your option) any later
  version.

  GerFuSp is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  GerFuSp.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef GERFUSP_SHIP_H
#define GERFUSP_SHIP_H


#include "gerfuspbase.h"
#include "reaction.h"
#include <gerq/dataobject.h>
#include <gerq/refcontainer.h>
#include <gerq/sqldataadapter.h>


namespace GerFuSp {


  class Ship: public GerQ::DataObject {

    public:

      Ship();
      virtual ~Ship();

      QString getName();
      void setName(const QString &aValue);

      Reaction *getReaction();
      void setReaction(Reaction *aValue);
      virtual double getReactiveShare() = ABSTRACT;
      virtual void setReactiveShare(double aValue) = ABSTRACT;
      double getEfficiency();
      void setEfficiency(double aValue);

      typedef enum {
        rrByShare,
	rrByEfficiency,
	rrByFuel
      } RecalcRule;

      double getStructure();
      void setStructure(double aValue);
      double getStructure_t();
      void setStructure_t(double aValue);
      double getConsumption();
      void setConsumption(double aValue);
      double getConsumption_kg_s();
      void setConsumption_kg_s(double aValue);

      double getPower();
      void setPower(double aValue, RecalcRule aRule);
      double getPower_W();
      void setPower_W(double aValue, RecalcRule aRule);
      double getDissipation();
      void setDissipation(double aValue, RecalcRule aRule);
      double getDissipation_W();
      void setDissipation_W(double aValue, RecalcRule aRule);
      virtual double getThrust() = ABSTRACT;
      virtual void setThrust(double aValue) = ABSTRACT;
      double getThrust_N();
      void setThrust_N(double aValue);
      double getAcceleration();
      void setAcceleration(double aValue);
      double getAcceleration_g();
      void setAcceleration_g(double aValue);

      QString getComments();
      void setComments(const QString &aValue);

      virtual QString getTypeName() = ABSTRACT;
      virtual QString getSpecifica() = ABSTRACT;

      double getExhaustVelocity();
      void setExhaustVelocity(double aValue, RecalcRule aRule);
      double getExhaustVelocity_c();
      void setExhaustVelocity_c(double aValue, RecalcRule aRule);
      double getExhaustVelocity_km_s();
      void setExhaustVelocity_km_s(double aValue, RecalcRule aRule);

      double getTravelSpeed();
      void setTravelSpeed(double aValue, RecalcRule aRule);
      virtual double getTravelSpeed_c() = ABSTRACT;
      virtual void setTravelSpeed_c(double aValue, RecalcRule aRule)
        = ABSTRACT;
      double getTravelSpeed_km_s();
      void setTravelSpeed_km_s(double aValue, RecalcRule aRule);

      double getSpecificImpulse();
      double getSpecificImpulse_km_s();
      double getSpecificImpulse_c();

      static GerQ::RefContainer *getTheContainer();

    private:

      QString fName;
      Reaction *fReaction;
      double fEfficiency;
      double fStructure;
      double fAcceleration;
      QString fComments;

      static GerQ::RefContainer *fTheContainer;

      static void doRead(GerQ::DataObject *aData, GerQ::SqlDataAdapter *aSql);
      static void doWrite(GerQ::DataObject *aData, GerQ::SqlDataAdapter *aSql);

      static const char* TABLE;
      static const char* KEY_ID;
      static const char* KEY_NAME;
      static const char* KEY_REACTION;
      static const char* KEY_EFFICIENCY;
      static const char* KEY_STRUCTURE;
      static const char* KEY_ACCELERATION;
      static const char* KEY_COMMENTS;

  }; // Ship


} // GerFuSp


#endif
