/*
  This file is part of GerFuSp.

  GerFuSp is free software: you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation, either version 3 of the License, or (at your option) any later
  version.

  GerFuSp is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  GerFuSp.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef GERFUSP_WNDMAIN_H
#define GERFUSP_WNDMAIN_H


#include "ship.h"
#include <QAction>
#include <QCloseEvent>
#include <QDialog>
#include <QLabel>
#include <QMainWindow>
#include <QMenu>
#include <QTableView>
#include <QVariant>
#include <QVBoxLayout>
#include <QWidget>


namespace GerFuSp {


  class WndMain: public QMainWindow{

    Q_OBJECT

    public:

      WndMain();

      void putShip(Ship *aShip);

      static WndMain *getTheWindow();

    protected:

      void closeEvent(QCloseEvent *aEvent);

    private:

      QMenu *fMnFile;
        QMenu *fMnNewShip;
	  QAction *fActNewRocket;
	  QAction *fActNewRamjet;
	QAction *fActEditShip;
	QAction *fActDeleteShip;
        QAction *fSepQuit;
        QAction *fActQuit;
      QMenu *fMnOptions;
        QAction *fActReactions;
	QAction *fActIces;
      QWidget *fWgtMain;
        QVBoxLayout *fBoxMain;
	  QLabel *fLbShips;
	  QTableView *fTblShips;
      QMenu *fCtxMnShips;
        QAction *fCtxActEditShip;
	QAction *fCtxActDeleteShip;

      void buildMenu();
      QMenu *getMnFile();
        QMenu *getMnNewShip();
	  QAction *getActNewRocket();
	  QAction *getActNewRamjet();
	QAction *getActEditShip();
	QAction *getActDeleteShip();
        QAction *getSepQuit();
        QAction *getActQuit();
      QMenu *getMnOptions();
        QAction *getActReactions();
	QAction *getActIces();
      QWidget *getWgtMain();
        QVBoxLayout *getBoxMain();
	  QLabel *getLbShips();
	  QTableView *getTblShips();
      QMenu *getCtxMnShips();
        QAction *getCtxActEditShip();
	QAction *getCtxActDeleteShip();

      QMap <QString, QDialog*> fShipDialogs;

      QDialog *getShipDialog(Ship *aShip);
      void dropShipDialog(Ship *aShip);

      static WndMain *fTheWindow;

      static const char* TITLE;
      static const char* ICON;

    private slots:

      void doNewRocket();
      void doNewRamjet();
      void doEditShip();
      void doDeleteShip();
      void doQuit();

      void doReactions();
      void doIces();

      void doCtxMnShips(const QPoint &aPoint);

  }; // WndMain


} // GerFuSp


#endif
